% =====================
% Journal of Water Economics — LaTeX class (v1)
% Modes: submit, proof, final.
% Save as: jwe.cls
% =====================
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jwe}[2025/10/23 v1 Journal of Water Economics class]

% -----------------------------------------------------------------------------
% Modes (submit, proof, final)
% -----------------------------------------------------------------------------
\newif\if@jwe@submit   \@jwe@submitfalse
\newif\if@jwe@proof   \@jwe@prooffalse
\newif\if@jwe@final   \@jwe@finalfalse

\DeclareOption{submit}{\@jwe@submittrue}
\DeclareOption{proof}{\@jwe@prooftrue}
\DeclareOption{final}{\@jwe@finaltrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

% -----------------------------------------------------------------------------
% Base class
% -----------------------------------------------------------------------------
\LoadClass[a4paper,11pt]{article}

% -----------------------------------------------------------------------------
% Packages
% -----------------------------------------------------------------------------
% Math + theorems first
\RequirePackage{amsmath}
\RequirePackage{amsthm}
\RequirePackage{mathtools}
% Fonts next
\RequirePackage{newpxtext}
\RequirePackage{newpxmath}
% The rest
\RequirePackage{microtype}
\RequirePackage[dvipsnames]{xcolor}
\RequirePackage{geometry}
    \geometry{a4paper,margin=30mm}
\RequirePackage{graphicx}
\RequirePackage{pgfplots}
    \pgfplotsset{compat=1.18}
\RequirePackage{booktabs}
\RequirePackage{array}
\RequirePackage{siunitx}
    \sisetup{
      table-number-alignment = center,
      detect-weight = true,
      detect-mode = true,
      input-symbols = ( ) - +,}
    \newcolumntype{d}[1]{S[table-format=#1]}
    \newcommand{\se}[1]{\multicolumn{1}{c}{\normalsize(#1)}}
\RequirePackage{enumitem}
    \setlist{nosep}
\RequirePackage{natbib}
    \setcitestyle{authoryear,round,semicolon}
    \renewcommand{\refname}{References}
\RequirePackage{hyperref}
    \hypersetup{
      colorlinks = true,
      linkcolor  = NavyBlue,
      citecolor  = NavyBlue,
      urlcolor   = NavyBlue}
\RequirePackage{caption}
    \captionsetup{labelfont=bf}
\RequirePackage{fancyhdr}
    \setlength{\headheight}{14pt}
    \addtolength{\topmargin}{-2pt}
\RequirePackage{lastpage}
\RequirePackage{etoolbox}

% -----------------------------------------------------------------------------
% Proof mode: add watermark and line numbers
% -----------------------------------------------------------------------------
\if@jwe@proof
  \RequirePackage{lineno}
  \linenumbers
  \RequirePackage[color=red!10,fontsize=130pt,text=PROOF - JWE]{draftwatermark}
\fi

% -----------------------------------------------------------------------------
% Submit mode: add line numbers
% -----------------------------------------------------------------------------
\if@jwe@submit
  \RequirePackage{lineno}
  \linenumbers
\fi

% -----------------------------------------------------------------------------
% Spacing
% -----------------------------------------------------------------------------
\linespread{1.1}\selectfont

% -----------------------------------------------------------------------------
% Start page
% -----------------------------------------------------------------------------
\newcommand{\jweStartPage}[1]{\gdef\@jweStartPage{#1}}
\gdef\@jweStartPage{}

% -----------------------------------------------------------------------------
% Theorem styles
% -----------------------------------------------------------------------------
\theoremstyle{plain}
\newtheorem{theorem}{Theorem}
\newtheorem{proposition}{Proposition}
\newtheorem{lemma}{Lemma}
\newtheorem{corollary}{Corollary}
\theoremstyle{definition}
\newtheorem*{definition}{Definition}
\newtheorem{assumption}{Assumption}
\newtheorem{remark}{Remark}
\newtheorem*{example}{Example}

% -----------------------------------------------------------------------------
% Appendices (Appendix A: Title)
% -----------------------------------------------------------------------------
\newcommand{\StartAppendices}{%
  \appendix
  \setcounter{section}{0}\setcounter{subsection}{0}%
  \setcounter{table}{0}\setcounter{figure}{0}\setcounter{equation}{0}%
  %
  \renewcommand{\thesection}{\Alph{section}}%
  \renewcommand{\thesubsection}{\thesection.\arabic{subsection}}%
  \renewcommand{\thetable}{\thesection\arabic{table}}%
  \renewcommand{\thefigure}{\thesection\arabic{figure}}%
  \renewcommand{\theequation}{\thesection\arabic{equation}}%
  \makeatletter
  \@addtoreset{table}{section}%
  \@addtoreset{figure}{section}%
  \@addtoreset{equation}{section}%
  %
  \renewcommand{\section}{\@startsection{section}{1}{\z@}%
    {-3.5ex \@plus -1ex \@minus -.2ex}%
    {2.3ex \@plus.2ex}%
    {\normalfont\Large\bfseries}%
  }%
  \renewcommand{\@seccntformat}[1]{Appendix \csname the##1\endcsname:\quad}%
  \makeatother
}

% -----------------------------------------------------------------------------
% Header
% -----------------------------------------------------------------------------
\pagestyle{fancy}
\fancyhf{}
\newcommand{\jwejournal}{Journal of Water Economics}
\newcommand{\jweShortTitle}{}
\newcommand{\jweHeaderString}{\jwejournal\ \@jweVolume\ (\@jweYear)}
\fancyhead[L]{\jweHeaderString}
\fancyhead[R]{\jweShortTitle\quad\thepage}
\cfoot{}

\fancypagestyle{jwefirst}{%
  \fancyhf{}%
  \fancyhead[L]{\jwejournal\ \@jweVolume\ (\@jweYear):\ \@jweStartPage--\pageref*{LastPage}}%
  \fancyhead[R]{\@jweISSN}%
}

% -----------------------------------------------------------------------------
% Submit mode: neutral header
% -----------------------------------------------------------------------------
\if@jwe@submit
  \fancyhf{}
  \fancyhead[C]{Paper submitted to \textit{Journal of Water Economics}}
  \fancyhead[R]{\thepage}
  \renewcommand{\headrulewidth}{1pt}%
  \fancypagestyle{jwefirst}{%
  \fancyhf{}%
  \fancyhead[C]{Paper submitted to \textit{Journal of Water Economics}}
  \fancyhead[R]{\thepage}
  \renewcommand{\headrulewidth}{1pt}%
  }%
\fi

% -----------------------------------------------------------------------------
% Metadata
% -----------------------------------------------------------------------------
\newcommand{\JEL}[1]{\gdef\@JEL{#1}}
\newcommand{\Keywords}[1]{\gdef\@Keywords{#1}}
\newcommand{\Acknowledgements}[1]{\gdef\@Ack{#1}\gdef\jweAck{#1}}
\newcommand{\Disclosure}[1]{\gdef\@Disclosure{#1}}
\newcommand{\Corresponding}[2]{\gdef\@CorrName{#1}\gdef\@CorrEmail{#2}\gdef\jweCorrName{#1}\gdef\jweCorrEmail{#2}}
\newcommand{\Received}[1]{\gdef\@Received{#1}}
\newcommand{\Accepted}[1]{\gdef\@Accepted{#1}}
\newcommand{\Online}[1]{\gdef\@Online{#1}}
\newcommand{\jweRunningTitle}[1]{\gdef\jweShortTitle{#1}}
\newcommand{\jweVolume}[1]{\gdef\@jweVolume{#1}}
\newcommand{\jweYear}[1]{\gdef\@jweYear{#1}}
\newcommand{\jweDOI}[1]{\gdef\@jweDOI{#1}}
\newcommand{\jweSetISSN}[1]{\gdef\@jweISSN{#1}}
%
\gdef\@JEL{} \gdef\@Keywords{} \gdef\@Ack{} \gdef\@Disclosure{}
\gdef\@CorrName{} \gdef\@CorrEmail{}
\gdef\@Received{} \gdef\@Accepted{} \gdef\@Online{}
\gdef\jweShortTitle{}%
\gdef\@jweVolume{} \gdef\@jweYear{} \gdef\@jweDOI{}
\gdef\@jweISSN{1234-5678}
%
\newcommand{\jweCorrName}{}
\newcommand{\jweCorrEmail}{}
\newcommand{\jweAck}{}

% -----------------------------------------------------------------------------
% Submit mode: hide metadata
% -----------------------------------------------------------------------------
\if@jwe@submit
  \renewcommand{\Corresponding}[2]{}%
  \renewcommand{\Acknowledgements}[1]{}%
  \renewcommand{\Disclosure}[1]{}%
  \gdef\jweCorrName{}%
  \gdef\jweCorrEmail{}%
  \gdef\jweAck{}%
  \gdef\@Ack{}%
  \gdef\@Disclosure{}%
\fi

% -----------------------------------------------------------------------------
% Author blocks
% -----------------------------------------------------------------------------
\gdef\@AuthorBlocks{}
\newcommand{\AddAuthor}[2]{%
  \g@addto@macro\@AuthorBlocks{%
    {\large #1\par}\vspace{0.25ex}%
    {\small #2\par}\vspace{0.75ex}%
  }%
}
\newcommand{\RenderAuthors}{%
  \ifx\@AuthorBlocks\@empty
    \ClassError{jwe}{No authors defined. Use \string\AddAuthor{name}{affiliation}}{}
  \else
    \@AuthorBlocks
  \fi
}

% -----------------------------------------------------------------------------
% Submit mode: hide authors blocks
% -----------------------------------------------------------------------------
\if@jwe@submit
  \renewcommand{\RenderAuthors}{\textit{Authors hidden for peer review}}
  \renewcommand{\AddAuthor}[2]{}
\fi

% -----------------------------------------------------------------------------
% First-page notes
% -----------------------------------------------------------------------------
\newif\ifjwe@hasnotes

\providecommand{\jweFirstPageNotes}{}
\renewcommand{\jweFirstPageNotes}{%
  \begingroup\parindent=0pt\footnotesize
  %
  \jwe@hasnotesfalse
  \if\relax\detokenize{\jweCorrName}\relax\else\jwe@hasnotestrue\fi
  \if\relax\detokenize{\jweAck}\relax\else\jwe@hasnotestrue\fi
  \if\relax\detokenize{\@Received}\relax\else\jwe@hasnotestrue\fi
  %
  \ifjwe@hasnotes
    \vspace{6pt}
    \noindent\rule{1\linewidth}{0.4pt}\par\vspace{1ex}
    \edef\jwe@tmp{\@Received\@Accepted\@Online}%
    \ifx\jwe@tmp\@empty\relax\else
      Manuscript received: \@Received; final version accepted: \@Accepted; available online: \@Online.\par\vspace{0.5ex}
    \fi
    © \@jweYear\ The Authors. Licensed under the Creative Commons Attribution 4.0 International License (CC BY 4.0).\par\vspace{0.5ex}
    Available at \url{https://www.journalofwatereconomics.com} and via the stable link \url{https://doi.org/\@jweDOI}.\par\vspace{-7ex}
  \fi
  \endgroup
}

% -----------------------------------------------------------------------------
% Submit mode: hide first-page notes
% -----------------------------------------------------------------------------
\if@jwe@submit
  \renewcommand{\jweFirstPageNotes}{}
\fi

% -----------------------------------------------------------------------------
% Abstract
% -----------------------------------------------------------------------------
\newcommand{\abstracttext}[1]{\gdef\@abstract{#1}}
\gdef\@abstract{}
%
\renewenvironment{abstract}
  {\par\noindent\centering\normalfont{\bfseries Abstract}\par\vspace{0.5ex}%
   \noindent
   \list{}{\setlength{\leftmargin}{0pt}\setlength{\rightmargin}{0pt}}%
   \item\relax\ignorespaces}
  {\unskip\endlist}
%
\newenvironment{jweabstract}
  {\par\noindent\begingroup\setlength{\parindent}{0pt}\begin{abstract}}
  {\end{abstract}\endgroup}

% -----------------------------------------------------------------------------
% Title block
% -----------------------------------------------------------------------------
\renewcommand{\maketitle}{%
  \begin{titlepage}
    \thispagestyle{jwefirst}%
    \par\vspace*{1em}
    \begin{center}
    {\LARGE\bfseries \@title\par}
    \vspace{4.5ex}
    %
    \RenderAuthors
    %
    \end{center}
    \vspace{2.5ex}
    %
    \begin{jweabstract}\@abstract\par\vspace{1ex}\end{jweabstract}
    \noindent\textbf{JEL:} \@JEL\par\vspace{0.5ex}
    \noindent\textbf{Keywords:} \@Keywords\par\vspace{3.5ex}
    %
    \noindent\rule{1\linewidth}{0.4pt}\par\vspace{4pt}
    %
    \ifx\jweCorrName\@empty\else
    \noindent\textbf{Corresponding author:} \jweCorrName\ (\href{mailto:\jweCorrEmail}{\jweCorrEmail}).
    \fi\par\vspace{0.5ex}
    %
    \ifx\jweAck\@empty\else
    \noindent\textbf{Acknowledgements:} \jweAck
    \fi\par\vspace{0.5ex}
    %
    \ifx\@Disclosure\@empty\else
    \noindent\textbf{Disclosure statement:} \@Disclosure
    \fi\par\vspace{0.5ex}
    %
    \vfill
    \noindent\parbox{\textwidth}{\jweFirstPageNotes}
  \end{titlepage}
    %
    \if@jwe@submit
    \setcounter{page}{2}%
    \else
    \ifx\@jweStartPage\@empty\else
    \setcounter{page}{\numexpr\@jweStartPage+1\relax}%
    \fi
    \fi
}